% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filterable.R, R/Filter.R
\docType{data}
\name{Filterable}
\alias{Filterable}
\alias{.obj}
\title{Abstract Class for Filterables}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Filterable

.obj()
}
\description{
\strong{Abstract classes} are exported for package developers that want to extend
them, they cannot be instantiated directly.

Superclass for classes that have a \code{filter()} method such as \link{Appenders} and
\link{Loggers}. This class is only exported for package developers that want to
extend it.
}
\section{Fields}{


\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Methods}{

\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\seealso{
Other abstract classes: \code{\link{AppenderDigest}},
  \code{\link{AppenderMail}}, \code{\link{AppenderMemory}},
  \code{\link{AppenderTable}}
}
\concept{abstract classes}
\keyword{datasets}
\keyword{internal}
