\name{reduce}
\alias{reduce}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Reduce the size of rule base}
\description{
    From given rule base, select such set of rules that influence mostly the rule base coverage of
    the input data.
}
\usage{
reduce(x, rules, ratio, 
       tnorm = c("minimum", "product", "lukasiewicz"),
       tconorm = c("maximum", "product", "lukasiewicz"),
       numThreads = 1)
}
\arguments{
    \item{x}{
        Data for the rules to be evaluated on. Could be either a numeric matrix or numeric vector.
        If matrix is given then the rules are evaluated on rows. Each value of the vector or column
        of the matrix represents a predicate - it's numeric value represents the truth values
        (values in the interval [0, 1]).
    }
    \item{rules}{
        Either an object of class "farules" or list of character vectors where each vector is a rule
        with consequent being the first element of the vector. Elements of the vectors (predicate
        names) must correspond to the \code{x}'s names (of columns if \code{x} is a matrix).
    }
    \item{ratio}{
        A percentage of rule base coverage that must be preserved. It must be a value within the
        \eqn{[0, 1]} interval. Value of 1 means that the rule base coverage of the result must be
        the same as coverage of input \code{rules}. A sensible value is e.g. 0.9.
    }
    \item{tnorm}{
        Which t-norm to use as a conjunction of antecedents. The default is minimum.
    }
    \item{tconorm}{
        Which t-norm to use as a disjunction, i.e. to combine multiple antecedents to get coverage
        of the rule base. The default is maximum.
    }
    \item{numThreads}{
        How many threads to use for computation. Value higher than 1 causes that the algorithm runs
        in several parallel threads (using the OpenMP library).
    }
}
\details{
    From a given rulebase, a rule with greatest coverage is selected. After that, additional rules
    are selected that increase the rule base coverage the most. Addition stops after the coverage
    exceeds \eqn{original coverage * ratio}.

    Note that the size of the resulting rule base is not necessarily minimal because the algorithm
    does not search all possible combination of rules. It only finds a local minimum of rule base
    size.
}
\value{
    Function returns an instance of class \code{\link{farules}} or a list depending on the type of
    the \code{rules} argument.
}
\references{
    M. Burda, M. Štěpnička, Reduction of Fuzzy Rule Bases Driven by the Coverage of Training Data,
    in: Proc. 16th World Congress of the International Fuzzy Systems
    Association and 9th Conference of the European Society for Fuzzy
    Logic and Technology (IFSA-EUSFLAT 2015), Advances in Intelligent
    Systems Research, Atlantic Press, Gijon, 2015.
}
\author{
    Michal Burda
}
%\note{
%%  ~~further notes~~
%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
  \code{\link{rbcoverage}},
  \code{\link{farules}}
}

%\examples{
%}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ robust }
\keyword{ multivariate }
