% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leptokurticMixture.R
\name{pmln}
\alias{pmln}
\title{Parsimonious model-based clustering with the multivariate elliptical leptokurtic-normal}
\usage{
pmln(
  data = NULL,
  G = 1:3,
  covModels = NULL,
  betaModels = "B",
  kml = c(1, 0, 1),
  label = NULL,
  scale.data = TRUE,
  veo = FALSE,
  iterMax = 1000,
  tol = 1e-08,
  pprogress = FALSE,
  method = "FP"
)
}
\arguments{
\item{data}{A n x p matrix of observations.}

\item{G}{A integer determine the number of components of the mixture model.}

\item{covModels}{if NULL fit 14 possible scale matrix structures. Otherwise a character vector where each element has length 3. e.g. c("VVV", "EEE") A character of length 4 such as "VVVV", indicating the model; the covariance and beta parameters. The 1st position controls, lambda, the volume; "V" varying across components or "E" equal across components. The 2nd position controls the eigenvalues; V" varying across components, "E" equal across components or "I" the identity matrix. The 3rd  position controls the orientation; "V" varying across components, "E" equal across components or "I" the identity matrix.}

\item{betaModels}{set to "V", "E", "B", "F". "V" varying across components, "E" equal across components, "B" consider both "V" & "E", "F" fixed at the maximum value.}

\item{kml}{a vector of length 3 indicating, the number of k-means starts, number of random starts and the number of EM iterations used for each start}

\item{label}{If \code{NULL} then the data has no known groups. If \code{is.integer} then some of the observations have known groups. If \code{label[i]=k} then observation belongs to group  \code{k}. If \code{label[i]=0} then observation has no known group.}

\item{scale.data}{Should the data be scaled before clustering. The default is TRUE.}

\item{veo}{"Variables exceed observations". If TRUE, fit the model even though the  number variables in the model exceeds the number of observations.}

\item{iterMax}{The maximum number of EM iterations for each model fitted.}

\item{tol}{The tol for the stopping rule; lack of progress. The default is 1e-6 but it depends on the data set.}

\item{pprogress}{If TRUE print the progress of the function.}

\item{method}{If FP use the fixed point iteration method otherwise if MM use the MM method.}
}
\value{
A list of
\itemize{
  \item startobject - A statement on how the models were initialized 
  \item gpar - A list of parameter values for the model choosen by the BIC
  \item loglik - A vector of the log-likelihoods values 
  \item z - A n x G matrix of the posterior probabilities from the model choosen by the BIC
  \item map - A vector the maximum a posteriori derived from z
  \item BIC - An array with dimensions (G, number of fitted models, 3). The last dimension indices the loglik, number of free parameters and BIC for each fitted model. 
  \item bicModel - Information as list on the model choosen by the BIC.
}
}
\description{
Performs parsimonious clustering with the multivariate elliptical leptokurtic-normal (MLN). There are 14 possible scale matrix structure and 2 for the kurtosis parameter for a total of 28 models.
}
\examples{
x1 = rmln(n=100, d=4, mu=rep(5,4), diag(4), beta=2)
x2 = rmln(n=100, d=4, mu=rep(-5,4), diag(4), beta=2)
x = rbind( x1,x2)
mlnFit = pmln(data=x, G=2, covModels=c("VVV", "EEE"), betaModels="B")
}
