% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_question.R
\name{search_question}
\alias{search_question}
\alias{legco_search_question}
\title{Search Question in LegCo}
\usage{
search_question(
  speaker_id = NULL,
  member_id = NULL,
  rundown_id = NULL,
  type = "all",
  lang = "en",
  from = "1900-01-01",
  to = Sys.Date(),
  floor = FALSE,
  n = 50,
  verbose = TRUE
)

legco_search_question(
  speaker_id = NULL,
  member_id = NULL,
  rundown_id = NULL,
  type = "all",
  lang = "en",
  from = "1900-01-01",
  to = Sys.Date(),
  floor = FALSE,
  n = 50,
  verbose = TRUE
)
}
\arguments{
\item{speaker_id}{the id of a speaker at the Legislative Council, or a vector
of ids. If \code{NULL}, returns all speakers. Defaults to \code{NULL}.}

\item{member_id}{the id of a LegCo member, or a vector of ids. If
\code{NULL}, returns results of all LegCo members. Defaults to \code{NULL}.}

\item{rundown_id}{the id of a rundown, or a vector of ids. If \code{NULL},
returns results of all rundowns. Defaults to \code{NULL}.}

\item{type}{the type of meeting. If \code{"open"}, returns open meetings. If
\code{"closed"}, returns closed meetings. If \code{"all"}, returns all
meetings. Defaults to \code{"all"}.}

\item{lang}{the language of hansard files to search from. \code{"en"} returns
the English version. \code{"zh"} returns the Traditional Chinese version.
Defaults to \code{"en"}.}

\item{from}{only fetch results of meetings on or after this date. Accepts
character values in \code{"YYYY-MM-DD"} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else
that can be coerced to a date with \code{as.Date()}. Defaults to
\code{"1900-01-01"}.}

\item{to}{only fetch results of meetings on or before this date. Accepts
character values in \code{"YYYY-MM-DD"} format, and objects of class
\code{Date}, \code{POSIXt}, \code{POSIXct}, \code{POSIXlt} or anything else
that can be coerced to a date with \code{as.Date()}. Defaults to the
current system date.}

\item{floor}{logical: whether to fetch results from the floor version of the
hansard files? The floor version is the first presented version of hansard
file in the original language delivered by the speakers in LegCo. If
\code{TRUE}, the language option is ignored. Defaults to \code{FALSE}.}

\item{n}{the number of record to fetch. Defaults to \code{50}.}

\item{verbose}{logical: Whether to display progress messages when fetching
data? Defaults to \code{TRUE}.}
}
\description{
Search full text of questions put to the government by LegCo member(s).
}
\details{
This is a complementary function to \code{\link{questions}()}.
}
\section{Functions}{
 Complementary Functions: \itemize{ \item
  \code{\link{search_committee}}: Search LegCo committees \item
  \code{\link{search_member}}: Search LegCo members \item
  \code{\link{search_voting_record}}: Search Voting Record in LegCo meetings
  \item \code{\link{search_question}}: Search full text of question put to
  the government by LegCo members}
}

\section{Notes}{
 The complementary functions work by calling a number of
  database functions and combining their output, meaning that a function call
  usually involves multiple API calls. Use with caution to prevent reaching
  the API’s rate limit too quickly.
}

