% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slope_rate_models.R
\name{lc_rate_est}
\alias{lc_rate_est}
\title{Learning Rate Estimate}
\usage{
lc_rate_est(T, t, n)
}
\arguments{
\item{T}{total time (or cost) required to produce the first n units}

\item{t}{time (or cost) required to produce the first unit}

\item{n}{total n units produced}
}
\description{
Computes the learning rate based on total time (cost) to produce the first n units, time (cost) required for the first unit and total units produced.
}
\examples{

# Estimate the learning curve rate for 250 units when the time
# for unit one took 80 hours and the total time for all 250
# units took 8,250 hours.

lc_rate_est(T = 8250, t = 80, n = 250)
## [1] 0.8947908
}

