% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{addRasterImage}
\alias{addRasterImage}
\alias{projectRasterForLeaflet}
\title{Add a raster image as a layer}
\usage{
addRasterImage(map, x, colors = "Spectral", opacity = 1,
  attribution = NULL, layerId = NULL, group = NULL, project = TRUE,
  maxBytes = 4 * 1024 * 1024)

projectRasterForLeaflet(x)
}
\arguments{
\item{map}{a map widget object}

\item{x}{a \code{RasterLayer} object--see \code{\link[raster]{raster}}}

\item{colors}{the color palette (see \code{\link{colorNumeric}}) or function
to use to color the raster values (hint: if providing a function, set
\code{na.color} to \code{"#00000000"} to make \code{NA} areas transparent)}

\item{opacity}{the base opacity of the raster, expressed from 0 to 1}

\item{attribution}{the HTML string to show as the attribution for this layer}

\item{layerId}{the layer id}

\item{group}{the name of the group this raster image should belong to (see
the same parameter under \code{\link{addTiles}})}

\item{project}{if \code{TRUE}, automatically project \code{x} to the map
projection expected by Leaflet (\code{EPSG:3857}); if \code{FALSE}, it's
the caller's responsibility to ensure that \code{x} is already projected,
and that \code{extent(x)} is expressed in WGS84 latitude/longitude
coordinates}

\item{maxBytes}{the maximum number of bytes to allow for the projected image
(before base64 encoding); defaults to 4MB.}
}
\description{
Create an image overlay from a \code{RasterLayer} object. \emph{This is only
suitable for small to medium sized rasters}, as the entire image will be
embedded into the HTML page (or passed over the websocket in a Shiny
context).
}
\details{
The \code{maxBytes} parameter serves to prevent you from accidentally
embedding an excessively large amount of data into your htmlwidget. This
value is compared to the size of the final compressed image (after the raster
has been projected, colored, and PNG encoded, but before base64 encoding is
applied). Set \code{maxBytes} to \code{Inf} to disable this check, but be
aware that very large rasters may not only make your map a large download but
also may cause the browser to become slow or unresponsive.

By default, the \code{addRasterImage} function will project the RasterLayer
\code{x} to EPSG:3857 using the \code{raster} package's
\code{\link[raster]{projectRaster}} function. This can be a time-consuming
operation for even moderately sized rasters. Upgrading the \code{raster}
package to 2.4 or later will provide a large speedup versus previous
versions. If you are repeatedly adding a particular raster to your Leaflet
maps, you can perform the projection ahead of time using
\code{projectRasterForLeaflet()}, and call \code{addRasterImage} with
\code{project=FALSE}.
}
\examples{
library(raster)

r <- raster(xmn=-2.8, xmx=-2.79, ymn=54.04, ymx=54.05, nrows=30, ncols=30)
values(r) <- matrix(1:900, nrow(r), ncol(r), byrow = TRUE)
crs(r) <- CRS("+init=epsg:4326")

leaflet() \%>\% addTiles() \%>\%
  addRasterImage(r, colors = "Spectral", opacity = 0.8)
}

