% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugin-graticule.R
\name{addGraticule}
\alias{addGraticule}
\title{Add a Graticule on the map
see \url{https://github.com/turban/Leaflet.Graticule}}
\usage{
addGraticule(map, interval = 20, sphere = FALSE, style = list(color =
  "#333", weight = 1), layerId = NULL, group = NULL,
  options = pathOptions(pointerEvents = "none", clickable = FALSE))
}
\arguments{
\item{map}{a map widget object}

\item{interval}{The spacing in map units between horizontal and vertical lines.}

\item{sphere}{boolean. Default FALSE}

\item{style}{path options for the generated lines. See \url{http://leafletjs.com/reference.html#path-options}}

\item{layerId}{the layer id}

\item{group}{the name of the group this layer belongs to.}

\item{options}{the path options for the graticule layer}
}
\description{
Add a Graticule on the map
see \url{https://github.com/turban/Leaflet.Graticule}
}
\examples{
library(leaflet)

leaf <- leaflet() \%>\%
  addTiles() \%>\%
  addGraticule()

}

