% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ldat.R
\name{as_ldat}
\alias{as_ldat}
\alias{as_ldat.data.frame}
\alias{as_ldat.default}
\alias{as_ldat.ldat}
\title{Convert r-objects to \code{\link{ldat}}'s}
\usage{
as_ldat(x, ...)

\method{as_ldat}{data.frame}(x, ...)

\method{as_ldat}{default}(x, ...)

\method{as_ldat}{ldat}(x, ...)
}
\arguments{
\item{x}{object to convert}

\item{...}{further arguments passed to or from other methods}
}
\value{
Returns a \code{ldat} with columns corresponding to the columns in \code{x}.
When \code{x} is not a \code{data.frame} it is first converted to a 
\code{data.frame} using a call to \code{\link{as.data.frame}}.
}
\description{
Convert r-objects to \code{\link{ldat}}'s
}
\examples{
a <- data.frame(a = 1:10, b = rnorm(10))
b <- as_ldat(a)

}

