% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{liouv.iTau}
\alias{liouv.iTau}
\title{Moment estimate for theta derived from Kendall's tau formula}
\usage{
liouv.iTau(tau_hat, family, alphavec)
}
\arguments{
\item{tau_hat}{estimated vector of Kendall's tau values}

\item{family}{family of the Liouville copula. Either \code{"clayton"} or \code{"gumbel"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}
}
\value{
Vector of theta
}
\description{
The moment estimates are based on inversion of the formula Kendall's tau for Clayton or Gumbel Liouville copula
}
\examples{
liouv.iTau(0.5,family="gumbel", c(1,2))
liouv.iTau(0.5,family="clayton", c(3,2))
}
