% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_RL_policy.R
\name{generate_RL_policy}
\alias{generate_RL_policy}
\title{Function performs RL and generates model policy}
\usage{
generate_RL_policy(x, states, actions, control)
}
\arguments{
\item{x}{- Dataframe containing trading data}

\item{states}{- Selected states of the System}

\item{actions}{- Selected actions executed under environment}

\item{control}{- control parameters as defined in the Reinforcement Learning Package}
}
\value{
Function returns data frame with reinforcement learning model policy
}
\description{
This function will perform Reinforcement Learning using Trading Data.
It will suggest whether or not it is better to keep using trading systems or not.
Function is just using results of the past performance to generate the recommendation (not a holy grail).
}
\details{
Initial policy is generated using a dummy zero values.
This way function starts working directly from the first observation.
However policy 'ON' value will only be generated once the Q value is greater than zero
}
\examples{

  library(tidyverse)
  library(ReinforcementLearning)
  library(magrittr)

  data(data_trades)
  states <- c("tradewin", "tradeloss")
  actions <- c("ON", "OFF")
  control <- list(alpha = 0.7, gamma = 0.3, epsilon = 0.1)
  generate_RL_policy(data_trades, states, actions, control)


}
\author{
(C) 2019 Vladimir Zhbanko
}
