% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilinestring.R
\name{lawn_multilinestring}
\alias{lawn_multilinestring}
\title{Create a multilinestring}
\usage{
lawn_multilinestring(coordinates, properties = NULL)
}
\arguments{
\item{coordinates}{A list of positions.}

\item{properties}{A list of properties.}
}
\value{
A \link{data-Feature}<(\link{data-MultiLineString})>
}
\description{
Create a multilinestring
}
\examples{
mlstr <- '[
  [
   [-21.964416, 64.148203],
   [-21.956176, 64.141316],
   [-21.93901, 64.135924],
   [-21.927337, 64.136673]
  ],
  [
   [-21.929054, 64.127985],
   [-21.912918, 64.134726],
   [-21.916007, 64.141016],
   [-21.930084, 64.14446]
  ]
]'
lawn_multilinestring(mlstr)

lawn_multilinestring(mlstr,
  properties = list(name = 'line1', distance = 145))

# Make a FeatureCollection
lawn_featurecollection(lawn_multilinestring(mlstr))

\dontrun{
lawn_featurecollection(lawn_multilinestring(mlstr)) \%>\% view
}
}
\seealso{
Other data functions: 
\code{\link{lawn_featurecollection}()},
\code{\link{lawn_feature}()},
\code{\link{lawn_filter}()},
\code{\link{lawn_geometrycollection}()},
\code{\link{lawn_linestring}()},
\code{\link{lawn_multipoint}()},
\code{\link{lawn_multipolygon}()},
\code{\link{lawn_point}()},
\code{\link{lawn_polygon}()},
\code{\link{lawn_random}()},
\code{\link{lawn_remove}()},
\code{\link{lawn_sample}()}
}
\concept{data functions}
