% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordeach.R
\name{lawn_coordeach}
\alias{lawn_coordeach}
\title{Iterate over property objects in any GeoJSON object}
\usage{
lawn_coordeach(x, fun = NULL, excludeWrapCoord = FALSE, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-GeoJSON} object}

\item{fun}{(character) a Javascript function. if not given, returns self}

\item{excludeWrapCoord}{(logical) whether or not to include
the final coordinate of LinearRings that wraps the ring in its iteration.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
matrix of coordinates, where each row in the matrix is a
coordinate pair
}
\description{
Iterate over property objects in any GeoJSON object
}
\examples{
x <- "{ type: 'Point', coordinates: [10, 50] }"

# don't apply any function, identity essentially
lawn_coordeach(x)

# appply a function callback
lawn_coordeach(x, "z.length === 2")
lawn_coordeach(lawn_data$points_count, "z.length === 2")

z <- '{
  "type": "FeatureCollection",
  "features": [
    {
      "type": "Feature",
      "properties": {
        "population": 200,
        "name": "things"
      },
      "geometry": {
        "type": "Point",
        "coordinates": [-112.0372, 46.608058]
      }
    }, {
      "type": "Feature",
      "properties": {
        "population": 600,
        "name": "stuff"
      },
      "geometry": {
        "type": "Point",
        "coordinates": [-112.045955, 46.596264]
      }
    }
    ]
}'
lawn_coordeach(z)
lawn_coordeach(z, "z.reduce(function(a, b) { return a + b; }, 0)")
}
