% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iid2.R
\name{iid2}
\alias{iid2}
\alias{iid2.lm}
\alias{iid2.gls}
\alias{iid2.lme}
\alias{iid2.lvmfit}
\alias{iid2.lm2}
\alias{iid2.gls2}
\alias{iid2.lme2}
\alias{iid2.lvmfit2}
\title{Extract corrected i.i.d. decomposition}
\usage{
iid2(object, ...)

\method{iid2}{lm}(object, param = NULL, data = NULL, bias.correct = TRUE,
  ...)

\method{iid2}{gls}(object, cluster = NULL, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{iid2}{lme}(object, param = NULL, data = NULL, bias.correct = TRUE,
  ...)

\method{iid2}{lvmfit}(object, param = NULL, data = NULL,
  bias.correct = TRUE, ...)

\method{iid2}{lm2}(object, cluster = NULL, param = NULL, data = NULL,
  robust = TRUE, ...)

\method{iid2}{gls2}(object, cluster = NULL, param = NULL, data = NULL,
  robust = TRUE, ...)

\method{iid2}{lme2}(object, cluster = NULL, param = NULL, data = NULL,
  robust = TRUE, ...)

\method{iid2}{lvmfit2}(object, cluster = NULL, data = NULL, ...)
}
\arguments{
\item{object}{a linear model or a latent variable model}

\item{...}{arguments to be passed to \code{sCorrect}.}

\item{param}{[named numeric vector] the fitted parameters.}

\item{data}{[data.frame] the data set.}

\item{bias.correct}{[logical] should the standard errors of the coefficients be corrected for small sample bias? Only relevant if the \code{sCorrect} function has not yet be applied to the object.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{robust}{[logical] if \code{FALSE}, the i.i.d. decomposition is rescaled such its the squared sum equals the model-based standard error (instead of the robust standard error).}
}
\value{
A matrix containing the 1st order influence function relative to each sample (in rows)
and each model coefficient (in columns).
}
\description{
Extract corrected i.i.d. decomposition from a gaussian linear model.
}
\details{
If argument \code{p} or \code{data} is not null, then the small sample size correction is recomputed to correct the influence function.
}
\examples{
n <- 5e1
p <- 3
X.name <- paste0("X",1:p)
link.lvm <- paste0("Y~",X.name)
formula.lvm <- as.formula(paste0("Y~",paste0(X.name,collapse="+")))

m <- lvm(formula.lvm)
distribution(m,~Id) <- sequence.lvm(0)
set.seed(10)
d <- sim(m,n)

## linear model
e.lm <- lm(formula.lvm,data=d)
iid.tempo <- iid2(e.lm, bias.correct = FALSE)
range(iid.tempo[,1:4]-iid(e.lm))

## latent variable model
e.lvm <- estimate(lvm(formula.lvm),data=d)
iid.tempo <- iid2(e.lvm, bias.correct = FALSE)
range(iid.tempo-iid(e.lvm))
## difference due to the use of the observed info matrix vs. the expected one.

## rescale i.i.d using model-based standard error
iid.tempo <- iid2(e.lvm, robust = FALSE, bias.correct = FALSE)
diag(crossprod(iid.tempo))-diag(vcov(e.lvm))

}
\seealso{
\code{\link{sCorrect}} to obtain \code{lm2}, \code{gls2}, \code{lme2}, or \code{lvmfit2} objects.
}
\concept{
small sample inference

iid decomposition
}
