% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{addLink}
\alias{addLink}
\alias{addLink.lvm}
\alias{addLink.lvm.reduced}
\title{Add a New Link Between Two Variables in a LVM}
\usage{
addLink(x, ...)

\method{addLink}{lvm}(x, var1, var2, covariance, allVars = vars(x),
  warnings = FALSE, ...)

\method{addLink}{lvm.reduced}(x, ...)
}
\arguments{
\item{x}{a lvm model}

\item{...}{additional arguments to be passed to lower levels functions.}

\item{var1}{the first variable (character) or a formula describing the link to be added to the lvm}

\item{var2}{the second variable (character). Only used if var1 is a character.}

\item{covariance}{does the link is bidirectional. Ignored if one of the variable is exogenous.}

\item{allVars}{all the existing variables.}

\item{warnings}{should a warning be displayed when no link is added}
}
\description{
Generic interface to add links to lvm objects.
}
\details{
The argument allVars is useful for \code{lvm.reduce} object where the command \code{vars(x)} does not return all variables. The command \code{vars(x, xlp = TRUE)} must be used instead.
}
\examples{
library(lava)
set.seed(10)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
m2 <- m

addLink(m, x1 ~ y1, covariance = FALSE)
addLink(m, y1 ~ x1, covariance = FALSE)
coef(addLink(m, y1 ~ y2, covariance = TRUE))

addLink(m2, "x1", "y1", covariance = FALSE)
addLink(m2, "y1", "x1", covariance = FALSE)
newM <- addLink(m, "y1", "y2", covariance = TRUE)
coef(newM)
}
