% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/zconfband.R
\name{confband}
\alias{confband}
\alias{forestplot}
\title{Add Confidence limits bar to plot}
\usage{
confband(x, lower, upper, center = NULL, delta = 0.07, centermark = 0.03,
  pch, blank = TRUE, vert = TRUE, polygon = FALSE, step = FALSE, ...)
}
\arguments{
\item{x}{Position (x-coordinate if vert=TRUE, y-coordinate otherwise)}

\item{lower}{Lower limit (if NULL no limits is added, and only the
center is drawn (if not NULL))}

\item{upper}{Upper limit}

\item{center}{Center point}

\item{delta}{Length of limit bars}

\item{centermark}{Length of center bar}

\item{pch}{Center symbol (if missing a line is drawn)}

\item{blank}{If TRUE a white ball is plotted before the center is
added to the plot}

\item{vert}{If TRUE a vertical bar is plotted. Otherwise a horizontal
bar is used}

\item{polygon}{If TRUE polygons are added between 'lower' and 'upper'.}

\item{step}{Type of polygon (step-function or piecewise linear)}

\item{...}{Additional low level arguments (e.g. col, lwd, lty,...)}
}
\description{
Add Confidence limits bar to plot
}
\examples{
plot(0,0,type="n",xlab="",ylab="")
confband(0.5,-0.5,0.5,0,col="darkblue")
confband(0.8,-0.5,0.5,0,col="darkred",vert=FALSE,pch=1,cex=1.5)

set.seed(1)
K <- 20
est <- rnorm(K); est[c(3:4,10:12)] <- NA
se <- runif(K,0.2,0.4)
x <- cbind(est,est-2*se,est+2*se,runif(K,0.5,2))
rownames(x) <- unlist(lapply(letters[seq(K)],function(x) paste(rep(x,4),collapse="")))
rownames(x)[which(is.na(est))] <- ""
signif <- sign(x[,2])==sign(x[,3])
forestplot(x,text.right=FALSE)
forestplot(x[,-4],sep=c(2,15),col=signif+1,box1=TRUE,delta=0.2,pch=16,cex=1.5)
##'
z <- seq(10)
zu <- c(z[-1],10)
plot(z,type="n")
confband(z,zu,rep(0,length(z)),col=Col("darkblue"),polygon=TRUE,step=TRUE)
confband(z,zu,zu-2,col=Col("darkred"),polygon=TRUE,step=TRUE)
##'
z <- seq(0,1,length.out=100)
plot(z,z,type="n")
confband(z,z,z^2,polygon="TRUE",col=Col("darkblue"))
}
\author{
Klaus K. Holst
}
\seealso{
\code{confband}
}
\keyword{iplot}

