

### Copyright 2001  Deepayan Sarkar <deepayan@stat.wisc.edu>
###
### This file is part of the lattice library for R.
### It is made available under the terms of the GNU General Public
### License, version 2, or at your option, any later version,
### incorporated herein by reference.
###
### This program is distributed in the hope that it will be
### useful, but WITHOUT ANY WARRANTY; without even the implied
### warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
### PURPOSE.  See the GNU General Public License for more
### details.
###
### You should have received a copy of the GNU General Public
### License along with this program; if not, write to the Free
### Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
### MA 02111-1307, USA

## the foll functions don't do much error checking yet



panel.abline <-
    function(a, b = NULL, h = numeric(0), v = numeric(0),
             col = add.line$col, lty = add.line$lty,
             lwd = add.line$lwd, ...)
{
    add.line <- trellis.par.get("add.line")
    
    if (!missing(a)) {
        if (inherits(a,"lm")) {
            coeff <- coef(a)
        }
        else if (!is.null(coef(a))) coeff <- coef(a)  # ????
        else coeff <- c(a,b)

        if (length(coeff)==1) coeff <- c(0, coeff)
        
        if (coeff[2]==0) h <- c(h, coeff[1])
        else {
            xx <- current.viewport()$xscale
            yy <- current.viewport()$yscale
            
            x <- numeric(0)
            y <- numeric(0)
            ll <- function(i, j, k, l)
                (yy[j]-coeff[1]-coeff[2]*xx[i]) *
                    (yy[l]-coeff[1]-coeff[2]*xx[k])
            
            if (ll(1,1,2,1)<=0) {
                y <- c(y, yy[1])
                x <- c(x, (yy[1]-coeff[1])/coeff[2])
            }
            
            if (ll(2,1,2,2)<=0) {
                x <- c(x, xx[2])
                y <- c(y, coeff[1] + coeff[2] * xx[2])
            }
            
            if (ll(2,2,1,2)<=0) {
                y <- c(y, yy[2])
                x <- c(x, (yy[2]-coeff[1])/coeff[2])
            }
            
            if (ll(1,2,1,1)<=0) {
                x <- c(x, xx[1])
                y <- c(y, coeff[1] + coeff[2] * xx[1])
            }
            
            if (length(x)>0)
                grid.lines(x=x, y = y, default.units="native",
                           gp = gpar(col=col, lty=lty, lwd=lwd))
        }
    }
    
    
    for(i in seq(along=h))
        grid.lines(y=rep(h[i],2), default.units="native", gp = gpar(col=col,lty=lty,lwd=lwd))

    for(i in seq(along=v))
        grid.lines(x=rep(v[i],2), default.units="native", gp = gpar(col=col,lty=lty,lwd=lwd))
    
}








panel.fill <-
    function(col=par("bg"), ...)
{
    grid.rect(gp=gpar(fill=col))
}












panel.grid <-
    function(h=3, v=3, col=reference.line$col, lty=reference.line$lty,
             lwd=reference.line$lwd, ...)
{
    reference.line <- trellis.par.get("reference.line")

    if (h>0)
        for(i in 1:h)
            grid.lines(y=rep(i/(h+1),2),
                       gp = gpar(col = col, lty = lty, lwd = lwd),
                       default.units="npc")

    if (v>0)
        for(i in 1:v)
            grid.lines(x=rep(i/(v+1),2),
                       gp = gpar(col = col, lty = lty, lwd = lwd),
                       default.units="npc")


    ## Cheating here a bit for h=-1, v=-1. Can't think of any neat way to
    ## get the actual `at' values of the panel (Can pass it in though)

    if (h<0)
    {
        scale <- current.viewport()$yscale
        at <- lpretty(scale)
        at <- at[at>scale[1] & at < scale[2]]
        for(i in seq(along=at))
            grid.lines(y=rep(at[i],2), default.units="native",
                       gp = gpar(col = col, lty = lty, lwd = lwd))
    }
    if (v<0)
    {
        scale <- current.viewport()$xscale
        at <- lpretty(scale)
        at <- at[at>scale[1] & at < scale[2]]
        for(i in seq(along=at))
            grid.lines(x=rep(at[i],2), default.units="native",
                       gp = gpar(col = col, lty = lty, lwd = lwd))
    }
}





panel.lmline <-
    function(x, y, ...) if (length(x)>0) panel.abline(lm(y ~ x), ...) 



prepanel.lmline <-
    function(x, y, ...)
{
    if (length(x)>0) {
        coeff <- coef(lm(y~x))
        tem <- coeff[1] + coeff[2] * range(x)
        list(xlim=range(x), ylim=range(y,tem), 
             dx=diff(range(x)), dy=diff(tem))         
    }
    else list(xlim=c(NA,NA), ylim=c(NA,NA), dx=NA, dy=NA)
}


panel.loess <-
    function(x, y, span = 2/3, degree = 1,
             family = c("symmetric", "gaussian"),
             evaluation = 50,
             lwd = add.line$lwd, lty = add.line$lty,
             col = add.line$col, ...)
{
    if (length(x)>0) {
        add.line <- trellis.par.get("add.line")
        
        smooth <- loess.smooth(x, y, span = span, family = family,
                               degree = degree, evaluation = evaluation)
        grid.lines(x=smooth$x, y=smooth$y, default.units = "native",
                   gp = gpar(col = col, lty = lty, lwd = lwd))
    }
}


prepanel.loess <-
    function(x, y, span = 2/3, degree = 1,
             family = c("symmetric", "gaussian"),
             evaluation = 50,
             lwd = add.line$lwd, lty = add.line$lty,
             col = add.line$col, ...)
{
    if (length(x)>0) {
        add.line <- trellis.par.get("add.line")
        
        smooth <- loess.smooth(x, y, span = span, family = family,
                               degree = degree, evaluation = evaluation)
        list(xlim = range(x,smooth$x),
             ylim = range(y,smooth$y),
             dx = diff(smooth$x),
             dy = diff(smooth$y))
    }
    else list(xlim=c(0,1), ylim=c(0,1), dx=1, dy=1)
}



# panel.smooth <-
#     function(x, y, span = 2/3, degree = 1, zero.line = FALSE,
#              family = c("symmetric", "gaussian"),
#              evaluation = 50,
#              lwd = add.line$lwd, lty = add.line$lty,
#              col = add.line$col, ...)
# {
#     if (zero.line) abline(h=0, ...)
#     panel.loess(x, y, span = span, family = family,
#                 degree = degree, evaluation = evaluation, ...)
#     panel.xyplot(x, ,y, ...)
# }
## base R function exists




panel.superpose <-
    function(x, y, subscripts, groups,
             col,
             col.line = superpose.line$col,
             col.symbol = superpose.symbol$col,
             pch = superpose.symbol$pch,
             cex = superpose.symbol$cex, 
             lty = superpose.line$lty,
             lwd = superpose.line$lwd,
             ...)
{

    if (length(x)>0) {


        if (!missing(col)) {
            if (missing(col.line)) col.line <- col
            if (missing(col.symbol)) col.symbol <- col
        }

        superpose.symbol <- trellis.par.get("superpose.symbol")
        superpose.line <- trellis.par.get("superpose.line")

        x <- as.numeric(x)
        y <- as.numeric(y)

        vals <- sort(unique(groups))
        nvals <- length(vals)
        col.line <- rep(col.line, length=nvals)
        col.symbol <- rep(col.symbol, length=nvals)
        pch <- rep(pch, length=nvals)
        lty <- rep(lty, length=nvals)
        lwd <- rep(lwd, length=nvals)
        cex <- rep(cex, length=nvals)

        for (i in seq(along=vals)) {
            id <- (groups[subscripts] == vals[i])
            if (any(id))
                panel.xyplot(x=x[id], y=y[id],
                             pch = pch[i], cex = cex[i],
                             col.line = col.line[i],
                             col.symbol = col.symbol[i],
                             lty = lty[i],
                             lwd = lwd[i], ...)
        }
    }
}








panel.mathdensity <-
    function(dmath = dnorm,
             args = list(mean = 0, sd = 1),
             n = 50,
             col = reference.line$col,
             lwd = reference.line$lwd, ...)
{

    reference.line <- trellis.par.get("reference.line")
    x <- do.breaks(endpoints = current.viewport()$xscale,
                   nint = n)
    y <- do.call("dmath", c(list(x = x),args))
    panel.xyplot(x = x, y = y, type = "l", col = col, lwd = lwd, ...)
    
}
