% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lcModels-class}
\alias{lcModels-class}
\title{\code{lcModels}: a list of \code{lcModel} objects}
\description{
The \code{lcModels} \code{S3} class represents a \code{list} of one or more \code{lcModel} objects.
This makes it easier to work with a collection of models in a more structured manner.

A list of models is outputted from the repeated estimation functions such as \code{\link[=latrendRep]{latrendRep()}}, \code{\link[=latrendBatch]{latrendBatch()}}, and \link[=latrend-estimation]{others}.
You can construct a list of models using the \code{\link[=lcModels]{lcModels()}} function.
}
\section{Functionality}{

\itemize{
\item \link[=print.lcModels]{Print} an argument summary for each of the models.
\item \link[=as.data.frame.lcModels]{Convert} to a \code{data.frame} of method arguments.
\item \link[=subset.lcModels]{Subset} the list.
\item Compute an \link[=metric]{internal metric} or \link[=externalMetric]{external metric}.
\item Obtain the best model according to \link[=min.lcModels]{minimizing} or \link[=max.lcModels]{maximizing} a \link[=latrend-metrics]{metric}.
\item Obtain the summed \link[=estimationTime]{estimation time}.
\item \link[=plotMetric]{Plot a metric} across a variable.
\item \link[=plotClusterTrajectories]{Plot the cluster trajectories}.
}
}

\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
models <- latrendRep(method, data = latrendData, .rep = 5) # 5 repeated runs

bestModel <- min(models, "MAE")
}
\seealso{
Other lcModels functions: 
\code{\link{as.lcModels}()},
\code{\link{lcModels}},
\code{\link{max.lcModels}()},
\code{\link{min.lcModels}()},
\code{\link{plotMetric}()},
\code{\link{print.lcModels}()},
\code{\link{subset.lcModels}()}
}
\concept{lcModels functions}
