% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{min.lcModels}
\alias{min.lcModels}
\title{Select the lcModel with the lowest metric value}
\usage{
\method{min}{lcModels}(x, name, ...)
}
\arguments{
\item{x}{The \code{lcModels} object}

\item{name}{The name of the internal metric.}

\item{...}{Additional arguments.}
}
\value{
The lcModel with the lowest metric value
}
\description{
Select the lcModel with the lowest metric value
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")

model1 <- latrend(method, latrendData, nClusters = 1)
model2 <- latrend(method, latrendData, nClusters = 2)
model3 <- latrend(method, latrendData, nClusters = 3)

models <- lcModels(model1, model2, model3)

min(models, "WMAE")
}
\seealso{
\link{max.lcModels} \link{externalMetric}
}
