% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_predict.R
\name{h2o_predict_MOJO}
\alias{h2o_predict_MOJO}
\alias{h2o_predict_binary}
\alias{h2o_predict_model}
\alias{h2o_predict_API}
\title{Calculate predictions of h2o Models}
\usage{
h2o_predict_MOJO(df, model_path, method = "mojo", batch = 300)

h2o_predict_binary(df, model_path, sample = NA)

h2o_predict_model(df, model)

h2o_predict_API(df, api, exclude = "tag")
}
\arguments{
\item{df}{Dataframe/Vector. Data to insert into the model.}

\item{model_path}{Character. Relative model path directory or zip file.}

\item{method}{Character. One of "mojo" or "json".}

\item{batch}{Integer. Run n batches at a time for "json" method.}

\item{sample}{Integer. How many rows should the function predict?}

\item{model}{h2o model Object}

\item{api}{Character. API URL.}

\item{exclude}{Character. Name of the variables to exclude.}
}
\value{
data.frame with predicted results.

vector with predicted results.

data.frame with predicted results.

vector with predicted results.
}
\description{
\code{h2o_predict_MOJO} lets the user predict using the h2o .zip file
containing the MOJO files. Note that it works with the files
generated when using the function export_results()

\code{h2o_predict_binary} lets the user predict using the h2o binary file.
Note that it works with the files generated when using the
function export_results(). Recommendation: use the
h2o_predict_MOJO() function when possible - it let's you change
h2o's version without problem.

\code{h2o_predict_model} lets the user get scores from a H2O Model Object.

\code{h2o_predict_API} lets the user get the score from an API service
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}
}
\concept{H2O}
\concept{Machine Learning}
