% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{ip_data}
\alias{ip_data}
\title{Scrap data based on IP address}
\usage{
ip_data(ip = myip(), quiet = FALSE)
}
\arguments{
\item{ip}{Vector. Vector with all IP's we wish to search.}

\item{quiet}{Boolean. Do not show the loading \code{statusbar}?}
}
\value{
data.frame. Each row is an unique \code{ip} address,
and columns will bee created for all the additional information found.
}
\description{
This function lets the user scrap https://db-ip.com/ given
IP address(es) to get their associated address type, ASN, ISP,
organization, country, state or region, county, city, ZIP postal code,
weather station, coordinates, Timezone, local time, languages, and currency.
}
\examples{
\donttest{
ip_data("163.114.132.0")
ip_data(ip = c(myip(), "201.244.197.199"), quiet = TRUE)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{files_functions}()},
\code{\link{font_exists}()},
\code{\link{formatColoured}()},
\code{\link{formatHTML}()},
\code{\link{get_credentials}()},
\code{\link{glued}()},
\code{\link{grepm}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{json2vector}()},
\code{\link{list_cats}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{move_files}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{warnifnot}()},
\code{\link{what_size}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{holidays}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_quote}()}
}
\concept{Scrapper}
\concept{Tools}
