% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_extras.R
\name{get_perimeter_patch}
\alias{get_perimeter_patch}
\title{get_perimeter_patch}
\usage{
get_perimeter_patch(classes, class_patches, resolution)
}
\arguments{
\item{classes}{A vector with unique values (output of get_unique_values_int)}

\item{class_patches}{A list with matrices of patches for each class (output of get_class_patches)}

\item{resolution}{A vector with two numbers (usually calculated using terra::res)}
}
\value{
A tibble with two columns: class, value
}
\description{
Perimeter of each patch in each class
}
\details{
Calculate perimeter of each patch in each class
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
landscape_mat <- terra::as.matrix(landscape, wide = TRUE)
classes <- landscapemetrics:::get_unique_values_int(landscape_mat)
class_patches <- get_class_patches(landscape_mat, classes, directions = 8)
pp <- get_perimeter_patch(classes, class_patches, terra::res(landscape))

}
\keyword{internal}
