% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_enn.R
\name{lsm_p_enn}
\alias{lsm_p_enn}
\alias{lsm_p_enn.RasterLayer}
\alias{lsm_p_enn.RasterStack}
\alias{lsm_p_enn.RasterBrick}
\alias{lsm_p_enn.stars}
\alias{lsm_p_enn.list}
\title{ENN (patch level)}
\usage{
lsm_p_enn(landscape, directions, verbose)

\method{lsm_p_enn}{RasterLayer}(landscape, directions = 8, verbose = TRUE)

\method{lsm_p_enn}{RasterStack}(landscape, directions = 8, verbose = TRUE)

\method{lsm_p_enn}{RasterBrick}(landscape, directions = 8, verbose = TRUE)

\method{lsm_p_enn}{stars}(landscape, directions = 8, verbose = TRUE)

\method{lsm_p_enn}{list}(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Euclidean Nearest-Neighbor Distance (Aggregation metric)
}
\details{
\deqn{ENN = h_{ij}}
where \eqn{h_{ij}} is the distance to the nearest neighbouring patch of
the same class i in meters

ENN is an 'Aggregation metric'. The distance to the nearest neighbouring patch of
the same class i. The distance is measured from edge-to-edge. The range is limited by the
cell resolution on the lower limit and the landscape extent on the upper limit. The metric
is a simple way to describe patch isolation.

\subsection{Units}{Meters}
\subsection{Range}{ENN > 0}
\subsection{Behaviour}{Approaches ENN = 0 as the distance to the nearest neighbour
decreases, i.e. patches of the same class i are more aggregated. Increases, without limit,
as the distance between neighbouring patches of the same class i increases, i.e. patches are
more isolated.}
}
\examples{
lsm_p_enn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

McGarigal, K., and McComb, W. C. (1995). Relationships between landscape
structure and breeding birds in the Oregon Coast Range.
Ecological monographs, 65(3), 235-260.
}
\seealso{
\code{\link{lsm_c_enn_mn}},
\code{\link{lsm_c_enn_sd}},
\code{\link{lsm_c_enn_cv}}, \cr
\code{\link{lsm_l_enn_mn}},
\code{\link{lsm_l_enn_sd}},
\code{\link{lsm_l_enn_cv}}
}
