% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_lsm.R
\name{list_lsm}
\alias{list_lsm}
\title{List landscape metrics}
\usage{
list_lsm(level = NULL, metric = NULL, name = NULL, type = NULL,
  what = NULL, simplify = FALSE, verbose = TRUE)
}
\arguments{
\item{level}{Level of metrics. Either 'patch', 'class' or 'landscape' (or vector with combination).}

\item{metric}{Abbreviation of metrics (e.g. 'area').}

\item{name}{Full name of metrics (e.g. 'core area')}

\item{type}{Type according to FRAGSTATS grouping (e.g. 'aggregation metrics').}

\item{what}{Selected level of metrics: either "patch", "class" or "landscape".
It is also possible to specify functions as a vector of strings, e.g. \code{what = c("lsm_c_ca", "lsm_l_ta")}.}

\item{simplify}{If true, function names are returned as vector.}

\item{verbose}{Print warning messages}
}
\value{
tibble
}
\description{
List landscape metrics
}
\details{
List all available landscape metrics depending on the provided filter
arguments. If an argument is not provided, automatically all possibilities are
selected. Therefore, to get \strong{all} available metrics, use simply \code{list_lsm()}.
For all arguments with exception of the \code{what} argument, it is also possible to
use a negative subset, i.e. all metrics  \strong{but} the selected ones. Therefore,
simply use e.g. \code{level = "-patch".} Furthermore, it is possible to only
get a vector with all function names instead of the full tibble.
}
\examples{
list_lsm(level = c("patch", "landscape"), type = "aggregation metric")
list_lsm(level = "-patch", type = "area and edge metric")
list_lsm(metric = "area", simplify = TRUE)

list_lsm(metric = "area", what = "lsm_p_shape")
list_lsm(metric = "area", what = c("patch", "lsm_l_ta"))
list_lsm(what = c("lsm_c_tca", "lsm_l_ta"))

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
