% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_contig.R
\name{lsm_p_contig}
\alias{lsm_p_contig}
\alias{lsm_p_contig.RasterLayer}
\alias{lsm_p_contig.RasterStack}
\alias{lsm_p_contig.RasterBrick}
\alias{lsm_p_contig.list}
\title{CONTIG (patch level)}
\usage{
lsm_p_contig(landscape, directions)

\method{lsm_p_contig}{RasterLayer}(landscape, directions = 8)

\method{lsm_p_contig}{RasterStack}(landscape, directions = 8)

\method{lsm_p_contig}{RasterBrick}(landscape, directions = 8)

\method{lsm_p_contig}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Contiguity index (Shape metric)
}
\details{
\deqn{CONTIG =  \frac{\Bigg[\frac{\sum\limits_{r=1}^z  c_{ijr}}{a_{ij}}\Bigg] - 1 }{ v - 1} }

where \eqn{c_{ijr}} is the contiguity value for pixel r in patch ij,
\eqn{a_{ij}} the area of the respective patch (number of cells) and \eqn{v} is
the size of the filter matrix (13 in this case).

CONTIG is a 'Shape metric'. It asses the spatial connectedness (contiguity) of
cells in patches. CONTIG coerces patch values to a value of 1 and the background
to NA. A nine cell focal filter matrix:\preformatted{filter_matrix <- matrix(c(1, 2, 1,
                          2, 1, 2,
                          1, 2, 1), 3, 3, byrow = T)
}

... is then used to weight orthogonally contiguous pixels more heavily than
diagonally contiguous pixels. Therefore, larger and more connections between
patch cells in the rookie case result in larger contiguity index values.

\subsection{Units}{None}
\subsection{Range}{0 >= CONTIG <= 1}
\subsection{Behaviour}{Equals 0 for one-pixel patches and increases to a limit
of 1 (fully connected patch).}
}
\examples{
lsm_p_contig(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

LaGro, J. 1991. Assessing patch shape in landscape mosaics.
Photogrammetric Engineering and Remote Sensing, 57(3), 285-293
}
\seealso{
\code{\link{lsm_c_contig_mn}},
\code{\link{lsm_c_contig_sd}},
\code{\link{lsm_c_contig_cv}}, \cr
\code{\link{lsm_l_contig_mn}},
\code{\link{lsm_l_contig_sd}},
\code{\link{lsm_l_contig_cv}}
}
