% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_p_cai.R
\name{lsm_p_cai}
\alias{lsm_p_cai}
\alias{lsm_p_cai.RasterLayer}
\alias{lsm_p_cai.RasterStack}
\alias{lsm_p_cai.RasterBrick}
\alias{lsm_p_cai.list}
\title{CAI (patch level)}
\usage{
lsm_p_cai(landscape, directions)

\method{lsm_p_cai}{RasterLayer}(landscape, directions = 8)

\method{lsm_p_cai}{RasterStack}(landscape, directions = 8)

\method{lsm_p_cai}{RasterBrick}(landscape, directions = 8)

\method{lsm_p_cai}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Core area index (Core area metric)
}
\details{
\deqn{CAI = (\frac{a_{ij}^{core}} {a_{ij}}) * 100}
where \eqn{a_{ij}^{core}} is the core area in square meters and \eqn{a_{ij}}
is the area in square meters.

CAI is a 'Core area metric'. It equals the percentage of a patch that is core area.
A cell is defined as core area if the cell has no neighbour with a different value
than itself (rook's case). It describes patch area and shape simultaneously (more core area
when the patch is large and the shape is rather compact, i.e. a square). Because the index is
relative, it is comparable among patches with different area.

\subsection{Units}{Percent}
\subsection{Range}{0 <= CAI <= 100}
\subsection{Behaviour}{CAI = 0 when the patch has no core area and
approaches CAI = 100 with increasing percentage of core area within a patch.}
}
\examples{
lsm_p_cai(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_core}},
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_c_cai_mn}},
\code{\link{lsm_c_cai_sd}},
\code{\link{lsm_c_cai_cv}},
\code{\link{lsm_c_cpland}}, \cr
\code{\link{lsm_l_cai_mn}},
\code{\link{lsm_l_cai_sd}},
\code{\link{lsm_l_cai_cv}}
}
