% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_area_mn.R
\name{lsm_l_area_mn}
\alias{lsm_l_area_mn}
\alias{lsm_l_area_mn.RasterLayer}
\alias{lsm_l_area_mn.RasterStack}
\alias{lsm_l_area_mn.RasterBrick}
\alias{lsm_l_area_mn.list}
\title{AREA_MN (landscape level)}
\usage{
lsm_l_area_mn(landscape, directions)

\method{lsm_l_area_mn}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_area_mn}{RasterStack}(landscape, directions = 8)

\method{lsm_l_area_mn}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_area_mn}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean of patch area (Area and edge metric)
}
\details{
\deqn{AREA_{MN} = mean(AREA[patch_{ij}])}
where \eqn{AREA[patch_{ij}]} is the area of each patch in hectares

AREA_MN is an 'Area and Edge metric'. The metric summarises the landscape
as the mean of all patch in the landscape. The metric is a simple way
to describe the composition of the landscape. Especially together with the total
landscape area (\code{\link{lsm_l_ta}}), it can also give an an idea of patch structure
(e.g. many small patches vs. few larges patches).

\subsection{Units}{Hectares}
\subsection{Range}{AREA_MN > 0}
\subsection{Behaviour}{Approaches AREA_MN = 0 if all patches are small. Increases, without
limit, as the patch areas increase.}
}
\examples{
lsm_l_area_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_area}},
\code{\link{mean}}, \cr
\code{\link{lsm_c_area_mn}},
\code{\link{lsm_c_area_sd}},
\code{\link{lsm_c_area_cv}} \cr
\code{\link{lsm_l_area_sd}},
\code{\link{lsm_l_area_cv}}
}
