% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_ndca.R
\name{lsm_c_ndca}
\alias{lsm_c_ndca}
\alias{lsm_c_ndca.RasterLayer}
\alias{lsm_c_ndca.RasterStack}
\alias{lsm_c_ndca.RasterBrick}
\alias{lsm_c_ndca.list}
\title{NDCA (class level)}
\usage{
lsm_c_ndca(landscape, directions)

\method{lsm_c_ndca}{RasterLayer}(landscape, directions = 8)

\method{lsm_c_ndca}{RasterStack}(landscape, directions = 8)

\method{lsm_c_ndca}{RasterBrick}(landscape, directions = 8)

\method{lsm_c_ndca}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Number of disjunct core areas (Core area metric)
}
\details{
\deqn{NDCA = \sum \limits_{j = 1}^{n} n_{ij}^{core}}
where \eqn{n_{ij}^{core}} is the number of disjunct core areas.

NDCA is a 'Core area metric'. The metric summarises class i as the sum of all
patches belonging to class i. A cell is defined as core if the cell has no
neighbour with a different value than itself (rook's case). NDCA counts the disjunct
core areas, whereby a core area is a 'patch within the patch' containing only core cells.
It describes patch area and shape simultaneously (more core area when the patch is large,
however, the shape must allow disjunct core areas). Thereby, a compact shape (e.g. a square)
will contain less disjunct core areas than a more irregular patch.

\subsection{Units}{None}
\subsection{Range}{NDCA >= 0}
\subsection{Behaviour}{NDCA = 0 when TCA = 0, i.e. every cell in patches of class i is
an edge. NDCA increases, with out limit, as core area increases and patch shapes allow
disjunct core areas (i.e. patch shapes become rather complex).}
}
\examples{
lsm_c_ndca(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_c_tca}}, \cr
\code{\link{lsm_p_ncore}},
\code{\link{lsm_l_ndca}}
}
