% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Registry.R
\name{Registry}
\alias{Registry}
\title{Registry}
\description{
A registry in a module.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{module}}{(\link{Module})\cr
The instance the registry belongs to.}

\item{\code{name}}{(\code{character(1)})\cr
The API for the instance.}

\item{\code{class_name}}{(\code{character(1)})\cr
The class name for the registry.}

\item{\code{is_link_table}}{(\code{logical(1)})\cr
Whether the registry is a link table.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Registry-new}{\code{Registry$new()}}
\item \href{#method-Registry-get}{\code{Registry$get()}}
\item \href{#method-Registry-df}{\code{Registry$df()}}
\item \href{#method-Registry-get_fields}{\code{Registry$get_fields()}}
\item \href{#method-Registry-get_field}{\code{Registry$get_field()}}
\item \href{#method-Registry-get_field_names}{\code{Registry$get_field_names()}}
\item \href{#method-Registry-get_record_class}{\code{Registry$get_record_class()}}
\item \href{#method-Registry-print}{\code{Registry$print()}}
\item \href{#method-Registry-to_string}{\code{Registry$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-new"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$new(instance, module, api, registry_name, registry_schema)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{The instance the registry belongs to.}

\item{\code{module}}{The module the registry belongs to.}

\item{\code{api}}{The API for the instance.}

\item{\code{registry_name}}{The name of the registry.}

\item{\code{registry_schema}}{The schema for the registry.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-get"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-get}{}}}
\subsection{Method \code{get()}}{
Get a record by ID or UID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$get(id_or_uid, include_foreign_keys = FALSE, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id_or_uid}}{The ID or UID of the record.}

\item{\code{include_foreign_keys}}{Logical, whether to include foreign keys in the record.}

\item{\code{verbose}}{Logical, whether to print verbose output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{Record} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-df"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-df}{}}}
\subsection{Method \code{df()}}{
Get a data frame summarising records in the registry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$df(limit = 100, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{Maximum number of records to return}

\item{\code{verbose}}{Boolean, whether to print progress messages}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame containing the available records
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-get_fields"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-get_fields}{}}}
\subsection{Method \code{get_fields()}}{
Get the fields in the registry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$get_fields()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of \link{Field} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-get_field"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-get_field}{}}}
\subsection{Method \code{get_field()}}{
Get a field by name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$get_field(field_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field_name}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{Field} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-get_field_names"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-get_field_names}{}}}
\subsection{Method \code{get_field_names()}}{
Get the field names in the registry.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$get_field_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of field names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-get_record_class"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-get_record_class}{}}}
\subsection{Method \code{get_record_class()}}{
Get the record class for the registry.

Note: This method is intended for internal use only and may be removed in the future.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$get_record_class()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{Record} class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-print"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{Registry}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Registry-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Registry-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of a \code{Registry}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Registry$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
