% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/verification.R
\name{confDistances_ex1}
\alias{confDistances_ex1}
\title{USGS verification example: model parameterisation (multiple distances)}
\usage{
confDistances_ex1(x = c(0, 0.3, 3.3, 6.6, 10, 20, 25, 30, 40, 50, 75, 100,
  150, 200), config = conf_ex1, dbg = FALSE)
}
\arguments{
\item{x}{vector of distances from the center of the recharge basin in the x
direction (L) (Default: 0 feet)}

\item{config}{name of configuration function (Default: conf_ex1)}

\item{dbg}{If True additional messages on debug messages}

\item{...}{further arguments passed to function "config"}
}
\description{
USGS verification example: model parameterisation (multiple distances)
}
\examples{
res <- confDistances_ex1()
if(FALSE){
#### Head for each time step (defined with parameter "numberTimeSteps)
xyplot(head ~ x | as.factor(sprintf("\%f days", timeSteps)),
       data=res$timeSteps,
       type="b",
       las=1,
       as.table=TRUE)
#### Head at end of simulation
plot(head ~ x,
     data=res$simTime,
     type="b",
     las=1)
}
#### Water level increase at end of simulation & compare to alternative models
modelComparison <- compareModelResults(conf = res)
plotModelComparison(modelComparison = modelComparison)
}
\references{
p.23, http://pubs.usgs.gov/sir/2010/5102/support/sir2010-5102.pdf
}

