% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmsurmiserelation.R
\name{kmsurmiserelation}
\alias{kmsurmiserelation}
\title{Compute the surmise relation of a quasi-ordinal knowledge space}
\usage{
kmsurmiserelation(x)
}
\arguments{
\item{x}{Binary matrix representing a quasi-ordinal knowledge space}
}
\value{
Binary matrix representing the surmise relation of the
corresponding quasi-ordinal knowledge space

Note: The columns of the surmise relation matrix describe the
minimal state for the respective item in the quasi-ordinal
knowledge space.
}
\description{
\code{kmsurmiserelation} returns a matrix representing the
surmise relation of a quasi-ordinal knowledge space. If \code{x}
is a general knowledge space, a knowledge structure or an
arbitrary family of sets, \code{kmsurmiserelation} returns the
surmise relation of the smallest quasi-ordinal knowledge space
containing \code{x}.
}
\examples{
kmsurmiserelation(xpl$space)

}
\seealso{
Other Different representations for knowledge spaces: 
\code{\link{kmbasis}()},
\code{\link{kmsf2basis}()},
\code{\link{kmsurmisefunction}()},
\code{\link{kmunionclosure}()}
}
\concept{Different representations for knowledge spaces}
