#' Knowledge spaces on reading and writing abilities
#'
#' Bases of knowledge spaces on reading/writing abilities obtained from querying
#' experts.
#'
#' Three experts were queried about prerequisite relationships between 48 items
#' on reading and writing abilities (Dowling, 1991; 1993). A forth basis represents
#' those prerequisite relationships on which the majority of the experts agree
#' (Dowling & Hockemeyer, 1998).
#'
#' @docType data
#'
#' @usage readwrite
#'
#' @format A list containing four bases (rw1 to rw3, and rwmaj) in binary
#' matrix form. Each matrix has 48 columns representing the different knowledge
#' items and a varying number of rows containing the basis elements.
#'
#' @references Dowling, C. E. (1991). Constructing Knowledge Structures from
#' the Judgements of Experts. Habilitationsschrift, Technische Universität
#' Carolo-Wilhelmina, Braunschweig, Germany.
#'
#' Dowling, C. E. (1993). Applying the basis of a knowledge space for controlling
#' the questioning of an expert. Journal of Mathematical Psychology, 37, 21–48.
#'
#' Dowling, C. E. & Hockemeyer, C. (1998). Computing the intersection of knowledge
#' spaces using only their basis. In Cornelia E. Dowling, Fred S. Roberts, & Peter
#' Theuns, editors, Recent Progress in Mathematical Psychology, pp. 133–141.
#' Lawrence Erlbaum Associates Ltd., Mahwah, NJ.
#'
#' @keywords data
#'
"readwrite"
