% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{all_labels}
\alias{all_labels}
\alias{all_rcpp_labels}
\title{Get all chunk labels in a document}
\usage{
all_labels(...)

all_rcpp_labels(...)
}
\arguments{
\item{...}{A vector of R expressions, each of which should return \code{TRUE}
or \code{FALSE}. The expressions are evaluated using the \emph{local} chunk
options of each code chunk as the environment, which means global chunk
options are not considered when evaluating these expressions. For example,
if you set the global chunk option \code{opts_chunk$set(purl = TRUE)},
\code{all_labels(purl == TRUE)} will \emph{not} return the labels of all
code chunks, but will only return the labels of those code chunks that have
local chunk options \code{purl = TRUE}.}
}
\value{
A character vector.
}
\description{
The function \code{all_labels()} returns all chunk labels as a character
vector. Optionally, you can specify a series of conditions to filter the
labels. The function `all_rcpp_labels()` is a wrapper function for
\code{all_labels(engine == 'Rcpp')}.
}
\details{
For example, suppose the condition expression is \code{engine == 'Rcpp'}, the
object \code{engine} is the local chunk option \code{engine}. If an
expression fails to be evaluated (e.g. when a certain object does not exist),
\code{FALSE} is returned and the label for this chunk will be filtered out.
}
\note{
Empty code chunks are always ignored, including those chunks that are
  empty in the original document but filled with code using chunk options
  such as \code{ref.label} or \code{code}.
}
\examples{
# the examples below are meaningless unless you put them in a knitr document
all_labels()
all_labels(engine == "Rcpp")
all_labels(echo == FALSE && results != "hide")
# or separate the two conditions
all_labels(echo == FALSE, results != "hide")
}
