% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinn.R
\name{kinn.train}
\alias{kinn.train}
\title{Builds kinn regression model}
\usage{
kinn.train(f, data, pre.process = T)
}
\arguments{
\item{f}{formula in the form y~x1+x2+...}

\item{data}{dataframe which contains training data}

\item{pre.process}{boolean flag which cluster data by density distributions}
}
\value{
kinn model object
}
\description{
Builds kinn regression model
}
\examples{
library(kinn)
x<-runif(100,min = 0,max=10)
e<-rnorm(100)
y<-2*x+3+e
df<-data.frame(x,y)
model=kinn.train("y~x",df)
}

