% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohen_d_over_n.R
\name{cohen_d_over_n}
\alias{cohen_d_over_n}
\title{Cohen's d as a function of sample size}
\usage{
cohen_d_over_n(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  save_as_png = FALSE,
  png_name = NULL,
  xlab = NULL,
  ylab = NULL,
  width = 16,
  height = 9
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable (grouping variable)}

\item{dv_name}{name of the dependent variable (measure variable
of interest)}

\item{save_as_png}{if \code{save = TRUE}, the plot will be saved
as a PNG file.}

\item{png_name}{name of the PNG file to be saved. By default, the name
will be "cohen_d_over_n_" followed by a timestamp of the
current time.
The timestamp will be in the format, jan_01_2021_1300_10_000001,
where "jan_01_2021" would indicate January 01, 2021;
1300 would indicate 13:00 (i.e., 1 PM); and 10_000001 would
indicate 10.000001 seconds after the hour.}

\item{xlab}{title of the x-axis for the histogram by group.
If \code{xlab = FALSE}, the title will be removed. By default
(i.e., if no input is given), \code{dv_name} will be used as
the title.}

\item{ylab}{title of the y-axis for the histogram by group.
If \code{ylab = FALSE}, the title will be removed. By default
(i.e., if no input is given), \code{iv_name} will be used as
the title.}

\item{width}{width of the plot to be saved. This argument will be
directly entered as the \code{width} argument for the \code{ggsave}
function within \code{ggplot2} package (default = 16)}

\item{height}{height of the plot to be saved. This argument will be
directly entered as the \code{height} argument for the \code{ggsave}
function within \code{ggplot2} package (default = 9)}
}
\value{
the output will be a list of (1) ggplot object
(histogram by group) and (2) a data.table with Cohen's d by sample size
}
\description{
Plot Cohen's d as sample size increases.
}
\examples{
\dontrun{
cohen_d_over_n(data = mtcars, iv_name = "am", dv_name = "mpg")
}
}
