% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_regression.R
\name{multiple_regression}
\alias{multiple_regression}
\title{Multiple regression}
\usage{
multiple_regression(
  data = NULL,
  formula = NULL,
  vars_to_mean_center = NULL,
  mean_center_vars = NULL,
  sigfigs = NULL,
  round_digits_after_decimal = NULL,
  round_p = NULL,
  pretty_round_p_value = TRUE,
  return_table_upper_half = FALSE,
  round_r_squared = 3,
  round_f_stat = 2,
  prettify_reg_table_col_names = TRUE,
  silent = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{formula}{a formula object for the regression equation}

\item{vars_to_mean_center}{(deprecated) a character vector specifying names
of variables that will be mean-centered before the regression model
is estimated}

\item{mean_center_vars}{a character vector specifying names
of variables that will be mean-centered before the regression model
is estimated}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}

\item{round_p}{number of decimal places to round p values
(overrides all other rounding arguments)}

\item{pretty_round_p_value}{logical. Should the p-values be rounded
in a pretty format (i.e., lower threshold: "<.001").
By default, \code{pretty_round_p_value = TRUE}.}

\item{return_table_upper_half}{logical. Should only the upper part
of the table be returned?
By default, \code{return_table_upper_half = FALSE}.}

\item{round_r_squared}{number of digits after the decimal both r-squared
and adjusted r-squared values should be rounded to (default 3)}

\item{round_f_stat}{number of digits after the decimal the f statistic
of the regression model should be rounded to (default 2)}

\item{prettify_reg_table_col_names}{logical. Should the column names
of the regression table be made pretty (e.g., change "std_beta" to
"Std. Beta")? (Default = \code{TRUE})}

\item{silent}{If \code{silent = FALSE}, a message regarding
mean-centered variables will be printed. If \code{silent = TRUE},
this message will be suppressed. By default, \code{silent = FALSE}.}
}
\value{
the output will be a data.table showing multiple regression
results.
}
\description{
Conduct multiple regression analysis and summarize the results
in a data.table.
}
\details{
To include standardized beta(s) in the regression results table,
the following package(s) must be installed prior to running the function:
Package 'lm.beta' v1.5-1 (or possibly a higher version) by
Stefan Behrendt (2014),
\url{https://cran.r-project.org/package=lm.beta}
}
\examples{
\donttest{
multiple_regression(data = mtcars, formula = mpg ~ gear * cyl)
multiple_regression(
data = mtcars, formula = mpg ~ gear * cyl,
mean_center_vars = "gear",
round_digits_after_decimal = 2)
}
}
