% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_data_from_qualtrics.R
\name{clean_data_from_qualtrics}
\alias{clean_data_from_qualtrics}
\title{Clean data from Qualtrics}
\usage{
clean_data_from_qualtrics(
  data = NULL,
  remove_survey_preview_data = TRUE,
  remove_test_respose_data = TRUE,
  default_cols_by_qualtrics = NULL,
  default_cols_by_qualtrics_new = NULL,
  warn_accuracy_loss = FALSE,
  click_data_cols = "rm",
  page_submit_cols = "move_to_right"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{remove_survey_preview_data}{logical. Whether to remove data
from survey preview (default = TRUE)}

\item{remove_test_respose_data}{logical. Whether to remove data
from test response (default = TRUE)}

\item{default_cols_by_qualtrics}{names of columns that Qualtrics
includes in the data set by default (e.g., "StartDate", "Finished").
Accepting the default value \code{default_cols_by_qualtrics = NULL}
will set the names to be those that Qualtrics uses as of Dec 25, 2020.}

\item{default_cols_by_qualtrics_new}{new names for columns that
Qualtrics includes in the data set by default
(e.g., "StartDate", "Finished").
Accepting the default value \code{default_cols_by_qualtrics_new = NULL}
will set the names to be those that Qualtrics uses as of Dec 25, 2020
converted to snake_case (e.g., "start_date", "finished").}

\item{warn_accuracy_loss}{logical. whether to warn the user if
converting character to numeric leads to loss of accuracy.
(default = FALSE)}

\item{click_data_cols}{if \code{click_data_cols = "rm"},
columns containing click data (e.g., "_First Click") will be
removed. If \code{click_data_cols = "move_to_right"}, the columns
will be moved to the right (end) of the data set.}

\item{page_submit_cols}{if \code{page_submit_cols = "rm"},
columns containing page submit data (e.g., "_Page Submit";
"response time" data) will be removed.
If \code{page_submit_cols = "move_to_right"}, the columns
will be moved to the right (end) of the data set.}
}
\value{
a data.table object
}
\description{
Clean a data set downloaded from Qualtrics
}
\examples{
clean_data_from_qualtrics(mtcars)
clean_data_from_qualtrics(mtcars, default_cols_by_qualtrics = "mpg",
default_cols_by_qualtrics_new = "mpg2")
}
