% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_discrete}
\alias{scale_tol_discrete}
\alias{scale_colour_bright}
\alias{scale_color_bright}
\alias{scale_fill_bright}
\alias{scale_colour_contrast}
\alias{scale_color_contrast}
\alias{scale_fill_contrast}
\alias{scale_colour_vibrant}
\alias{scale_color_vibrant}
\alias{scale_fill_vibrant}
\alias{scale_colour_muted}
\alias{scale_color_muted}
\alias{scale_fill_muted}
\alias{scale_colour_pale}
\alias{scale_color_pale}
\alias{scale_fill_pale}
\alias{scale_colour_dark}
\alias{scale_color_dark}
\alias{scale_fill_dark}
\alias{scale_colour_light}
\alias{scale_color_light}
\alias{scale_fill_light}
\title{Paul Tol's Discrete Colour Schemes for \pkg{ggplot2}}
\usage{
scale_colour_bright(..., reverse = FALSE, aesthetics = "colour")

scale_color_bright(..., reverse = FALSE, aesthetics = "colour")

scale_fill_bright(..., reverse = FALSE, aesthetics = "fill")

scale_colour_contrast(..., reverse = FALSE, aesthetics = "colour")

scale_color_contrast(..., reverse = FALSE, aesthetics = "colour")

scale_fill_contrast(..., reverse = FALSE, aesthetics = "fill")

scale_colour_vibrant(..., reverse = FALSE, aesthetics = "colour")

scale_color_vibrant(..., reverse = FALSE, aesthetics = "colour")

scale_fill_vibrant(..., reverse = FALSE, aesthetics = "fill")

scale_colour_muted(..., reverse = FALSE, aesthetics = "colour")

scale_color_muted(..., reverse = FALSE, aesthetics = "colour")

scale_fill_muted(..., reverse = FALSE, aesthetics = "fill")

scale_colour_pale(..., reverse = FALSE, aesthetics = "colour")

scale_color_pale(..., reverse = FALSE, aesthetics = "colour")

scale_fill_pale(..., reverse = FALSE, aesthetics = "fill")

scale_colour_dark(..., reverse = FALSE, aesthetics = "colour")

scale_color_dark(..., reverse = FALSE, aesthetics = "colour")

scale_fill_dark(..., reverse = FALSE, aesthetics = "fill")

scale_colour_light(..., reverse = FALSE, aesthetics = "colour")

scale_color_light(..., reverse = FALSE, aesthetics = "colour")

scale_fill_light(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{discrete_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \code{\link[ggplot2:discrete_scale]{discrete}} scale.
}
\description{
Provides qualitative colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
The qualitative colour schemes are used as given (no interpolation):
 colours are picked up to the maximum number of supported values.

 \tabular{ll}{
  \strong{Palette} \tab \strong{Max.} \cr
  bright \tab 7 \cr
  contrast \tab 3 \cr
  vibrant \tab 7 \cr
  muted \tab 9 \cr
  pale \tab 6 \cr
  dark \tab 6 \cr
  light \tab 9 \cr
 }
}
\section{Qualitative colour schemes}{

 According to Paul Tol's technical note, the \code{bright}, \code{contrast},
 \code{vibrant} and \code{muted} colour schemes are colour-blind safe.

 The \code{light} colour scheme is reasonably distinct for both normal or
 colour-blind vision and is intended to fill labelled cells.

 The \code{pale} and \code{dark} schemes are not very distinct in either
 normal or colour-blind vision and should be used as a text background or
 to highlight a cell in a table.

 Refer to the original document for details about the recommended uses (see
 references).
}

\examples{
library(ggplot2)

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_bright()

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_vibrant()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_muted()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_pale()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_dark()

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_light()
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
 SRON/EPS/TN/09-002, issue 3.1.
 URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other colour-blind safe colour schemes: 
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}

Other qualitative colour schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()},
\code{\link{scale_colour_stratigraphy}()},
\code{\link{scale_okabeito_discrete}}

Other Paul Tol's colour schemes: 
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
\concept{colour-blind safe colour schemes}
\concept{qualitative colour schemes}
