% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khisr-package.R, R/utils-ui.R
\name{khis-configuration}
\alias{khis-configuration}
\alias{with_khis_quiet}
\alias{local_khis_quiet}
\title{khisr Configuration}
\usage{
with_khis_quiet(code)

local_khis_quiet(env = parent.frame())
}
\arguments{
\item{code}{Code to execute quietly}

\item{env}{The environment to use for scoping}
}
\value{
No return value, called for side effects

No return value, called for side effects

No return value, called for side effects
}
\description{
Some aspects of khisr behaviour can be controlled via an option.
}
\section{Messages}{


The \code{khis_quiet} option can be used to suppress messages form khisr. By
default, khisr always messages, i.e. it is \emph{not} quiet.

set \code{khis_quiet} to \code{TRUE} to suppress message, by one of these means,
in order of decreasing scope:
\itemize{
\item Put \code{options(khis_quiet = TRUE)} in the start-up file, such as \code{.Rprofile},
or  in your R script.
\item Use \code{local_khis_quiet()} to silence khisr in a specific scope.
\item Use \code{with_khis_quite} to run small bit of code silently.
}

\code{local_khis_quiet} and \code{with_khis} follow the conventions of the
\href{https://withr.r-lib.org}{withr} package.
}

\examples{
# message: "The credentials have been set."
khis_cred(username = 'username', password = 'password')

# suppress messages for a small amount of code
with_khis_quiet(
  khis_cred(username = 'username', password = 'password')
)
# message: "The credentials have been set."
khis_cred(username = 'username', password = 'password')

# suppress messages for a in a specific scope
local_khis_quiet()

# no message
khis_cred(username = 'username', password = 'password')

# clear credentials
khis_cred_clear()
}
