% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_convnext_tiny}
\alias{application_convnext_tiny}
\title{Instantiates the ConvNeXtTiny architecture.}
\usage{
application_convnext_tiny(
  model_name = "convnext_tiny",
  include_top = TRUE,
  include_preprocessing = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000L,
  classifier_activation = "softmax"
)
}
\arguments{
\item{model_name}{String, name for the model.}

\item{include_top}{Whether to include the fully-connected
layer at the top of the network. Defaults to \code{TRUE}.}

\item{include_preprocessing}{Boolean, whether to include the preprocessing layer at the bottom of the network.}

\item{weights}{One of \code{NULL} (random initialization),
\code{"imagenet"} (pre-training on ImageNet-1k), or the path to the weights
file to be loaded. Defaults to \code{"imagenet"}.}

\item{input_tensor}{Optional Keras tensor
(i.e. output of \code{layers.Input()})
to use as image input for the model.}

\item{input_shape}{Optional shape tuple, only to be specified
if \code{include_top} is \code{FALSE}.
It should have exactly 3 inputs channels.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}. Defaults to \code{NULL}.
\itemize{
\item \code{NULL} means that the output of the model will be
the 4D tensor output of the last convolutional layer.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional layer, and thus
the output of the model will be a 2D tensor.
\item \code{max} means that global max pooling will
be applied.
}}

\item{classes}{Optional number of classes to classify images
into, only to be specified if \code{include_top} is \code{TRUE}, and
if no \code{weights} argument is specified. Defaults to 1000 (number of
ImageNet classes).}

\item{classifier_activation}{A \code{str} or callable. The activation function to use
on the "top" layer. Ignored unless \code{include_top=TRUE}. Set
\code{classifier_activation=NULL} to return the logits of the "top" layer.
Defaults to \code{"softmax"}.
When loading pretrained weights, \code{classifier_activation} can only
be \code{NULL} or \code{"softmax"}.}
}
\value{
A model instance.
}
\description{
Instantiates the ConvNeXtTiny architecture.
}
\section{References}{
\itemize{
\item \href{https://arxiv.org/abs/2201.03545}{A ConvNet for the 2020s}
(CVPR 2022)
}

For image classification use cases, see
\href{https://keras.io/api/applications/#usage-examples-for-image-classification-models}{this page for detailed examples}.
For transfer learning use cases, make sure to read the
\href{https://keras.io/guides/transfer_learning/}{guide to transfer learning & fine-tuning}.

The \code{base}, \code{large}, and \code{xlarge} models were first pre-trained on the
ImageNet-21k dataset and then fine-tuned on the ImageNet-1k dataset. The
pre-trained parameters of the models were assembled from the
\href{https://github.com/facebookresearch/ConvNeXt}{official repository}. To get a
sense of how these parameters were converted to Keras compatible parameters,
please refer to
\href{https://github.com/sayakpaul/keras-convnext-conversion}{this repository}.
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For ConvNeXt, preprocessing is included in the model using a \code{Normalization}
layer.  ConvNeXt models expect their inputs to be float or uint8 tensors of
pixels with values in the \verb{[0-255]} range.

When calling the \code{summary()} method after instantiating a ConvNeXt model,
prefer setting the \code{expand_nested} argument \code{summary()} to \code{TRUE} to better
investigate the instantiated model.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/convnext#convnexttiny-function}
}
}
