% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-wrappers.R
\name{bidirectional}
\alias{bidirectional}
\title{Bidirectional wrapper for RNNs.}
\usage{
bidirectional(object, layer, merge_mode = "concat", input_shape = NULL,
  batch_input_shape = NULL, batch_size = NULL, dtype = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{layer}{Recurrent instance.}

\item{merge_mode}{Mode by which outputs of the forward and backward RNNs will
be combined. One of 'sum', 'mul', 'concat', 'ave', NULL. If NULL, the
outputs will not be combined, they will be returned as a list.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Bidirectional wrapper for RNNs.
}
\seealso{
Other layer wrappers: \code{\link{time_distributed}}
}
