% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{constraint_maxnorm}
\alias{constraint_maxnorm}
\title{MaxNorm weight constraint}
\usage{
constraint_maxnorm(max_value = 2, axis = 0)
}
\arguments{
\item{max_value}{The maximum norm for the incoming weights.}

\item{axis}{The axis along which to calculate weight norms. For instance, in
a dense layer the weight matrix has shape \code{input_dim, output_dim},
set \code{axis} to \code{0} to constrain each weight vector of length \code{input_dim,}.
In a convolution 2D layer with \code{dim_ordering="tf"}, the weight tensor has
shape \code{rows, cols, input_depth, output_depth}, set \code{axis} to \code{c(0, 1, 2)}
to constrain the weights of each filter tensor of size \code{rows, cols, input_depth}.}
}
\description{
Constrains the weights incident to each hidden unit to have a norm less than
or equal to a desired value.
}
\seealso{
\href{http://www.cs.toronto.edu/~rsalakhu/papers/srivastava14a.pdf}{Dropout: A Simple Way to Prevent Neural Networks from Overfitting Srivastava, Hinton, et al. 2014}

Other constraints: \code{\link{constraint_minmaxnorm}},
  \code{\link{constraint_nonneg}},
  \code{\link{constraint_unitnorm}}
}
