% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runAR.R
\name{runAR}
\alias{runAR}
\title{Running Autocorrelations}
\usage{
runAR(data, wsize = 25)
}
\arguments{
\item{data}{\emph{N} x \emph{v} dataframe where \emph{N} is the no. of time points and \emph{v} the no. of variables}

\item{wsize}{Window size}
}
\value{
Running autocorrelations time series
}
\description{
Extracts the running autocorrelations by sliding a window comprised of \code{wsize} time points, and in each window, the autocorrelation for each variable is computed.
Each time the window is slid, the oldest time point is discarded and the latest time point is added.
}
\examples{
phase1=cbind(rnorm(50,0,1),rnorm(50,0,1)) #phase1: AutoCorr=0
phase2=cbind(rnorm(50,0,1),rnorm(50,0,1))
phase2=filter(phase2,.50, method="recursive") #phase2: AutoCorr=.5
X=rbind(phase1,phase2)
RS=runAR(data=X,wsize=25)
ts.plot(RS, gpars=list(xlab="Window", ylab="Autocorrelation", col=1:2,lwd=2))
}
