% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTest.R
\name{permTest}
\alias{permTest}
\title{KCP Permutation Test}
\usage{
permTest(data, RS_fun, wsize = 25, nperm = 1000, Kmax = 10,
  alpha = 0.05, varTest = FALSE)
}
\arguments{
\item{data}{data \emph{N} x \emph{v} dataframe where \emph{N} is the number of time points and \emph{v} the number of variables}

\item{RS_fun}{Running statistics function: Should require the time series and \code{wsize} as input and return a dataframe of running statistics
as output. This output dataframe should have rows that correspond to the time windows and columns that correspond to the variable(s) on which the running statistics were computed.}

\item{wsize}{Window size}

\item{nperm}{Number of permutations to be used in the permutation test}

\item{Kmax}{Maximum number of change points desired}

\item{alpha}{Significance level of the permutation test}

\item{varTest}{If FALSE, only the variance DROP test is implemented, and if TRUE, both the variance and the variance DROP tests are implemented.}
}
\value{
\item{sig}{Significance of having at least one change point. 0 - Not significant, 1- Significant}
\item{p_var_test}{P-value of the variance test.}
\item{p_varDrop_test}{P-value of the variance drop test.}
\item{perm_rmin}{A matrix of minimized variance criterion for the permuted data.}
}
\description{
The KCP permutation test implements the variance test and the variance drop test to determine if there is at least one change point in the running statistics
}
\references{
\cite{Cabrieto, J., Tuerlinckx, F., Kuppens, P., Hunyadi, B., & Ceulemans, E. (2018). Testing for the presence of correlation changes
in a multivariate time series: A permutation based approach. Scientific Reports, 8, 769, 1-20.} \url{https://doi.org/10.1038/s41598-017-19067-2}
}
