% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable2kable.R
\name{xtable2kable}
\alias{xtable2kable}
\title{Convert xtable to a kable object}
\usage{
xtable2kable(x, ...)
}
\arguments{
\item{x}{an xtable object}

\item{...}{options for print.xtable}
}
\description{
This function allow users to turn an xtable object into a kable
so they can use most of kableExtra's functions with their xtable code without
making too many changes. Note that although I tested many cases and it seems
to work, this function may not be functional in some other cases. I'm not
a regular xtable user and can only provide very limited support for this
function.

You should use this table in the same way as \code{print.xtable}. All the options
you provided to this function will be sent to \code{print.xtable}. Instead of
printing out the result, this function will return the LaTeX or HTML as
text and a kable object.
}
\examples{
\dontrun{
library(xtable)
xtable(mtcars) \%>\%
  xtable2kable(booktabs = TRUE) \%>\%
  kable_styling(latex_options = "striped")
}

}
