% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_to_df_logical.r
\name{factor_to_df}
\alias{factor_to_df}
\alias{factorToDataframeLogical}
\title{Convert factor into a data.frame of logicals}
\usage{
factor_to_df(fctr, prefix = deparse(substitute(fctr)), sep = "",
  drop_empty = TRUE, na_as_col = TRUE, verbose = FALSE)

factorToDataframeLogical(fctr, prefix = deparse(substitute(fctr)),
  sep = "", drop_empty = TRUE, na_as_col = TRUE, verbose = FALSE)
}
\arguments{
\item{fctr}{factor}

\item{prefix}{defaults to "f" to pre-pend the factor level when constructing
the data frame columns names}

\item{sep}{scalar character, introduced between factor names and levels when
forming new data frame column names}

\item{drop_empty}{logical, if `TRUE` (the default) factor levels with no
associated values are dropped.}

\item{na_as_col}{logical scalar: if NA data and/or NA levels, then covert to
NA strings and expand these as for any other factor}

\item{verbose}{single logical value, if \code{TRUE} then produce verbose
messages}
}
\value{
data.frame with columns of logicals
}
\description{
Convert a single factor into a data.frame with multiple true or false fields,
one for each factor. The `vtreat` package may be a better choice for more
comprehensive data preparation.
}
\examples{
n <- 10
m <- 20
l <- LETTERS[seq_len(n)]
set.seed(1441)
f <- factor(sample(l, m, replace = TRUE), levels = l)
g <- factor_to_df(f, drop_empty = FALSE)
print(g)
stopifnot(nrow(g) == m, ncol(g) == n)
factor_to_df(
  shuffle(factor(shuffle(LETTERS[1:10]))),
  prefix = ""
)
factor_to_df(factor(c(NA, 1, 2, 3)))
factor_to_df(factor(c(NA, 1, 2, 3)), na_as_col = FALSE)
}
