% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_predictions.R
\name{make_predictions}
\alias{make_predictions}
\alias{make_predictions.default}
\title{Generate predicted data for plotting results of regression models}
\usage{
make_predictions(model, ...)

\method{make_predictions}{default}(model, pred, pred.values = NULL,
  at = NULL, data = NULL, center = TRUE, interval = TRUE,
  int.type = c("confidence", "prediction"), int.width = 0.95,
  outcome.scale = "response", robust = FALSE, cluster = NULL,
  vcov = NULL, set.offset = NULL, new_data = NULL,
  return.orig.data = FALSE, partial.residuals = FALSE, ...)
}
\arguments{
\item{model}{The model (e.g., \code{lm}, \code{glm}, \code{merMod}, \code{svyglm})}

\item{...}{Ignored.}

\item{pred}{The name of the focal predictor as a string. This is the variable
for which, if you are plotting, you'd likely have along the x-axis (with
the dependent variable as the y-axis).}

\item{pred.values}{The values of \code{pred} you want to include. Default is NULL,
which means a sequence of equi-spaced values over the range of a numeric
predictor or each level of a non-numeric predictor.}

\item{at}{If you want to manually set the values of other variables in the
model, do so by providing a named list where the names are the variables
and the list values are vectors of the values. This can be useful
especially when you are exploring interactions or other conditional
predictions.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{center}{Set numeric covariates to their mean? Default is TRUE. You
may also just provide a vector of names (as strings) of covariates to
center. Note that for \code{svyglm} models, the survey-weighted means are used.
For models with weights, these are weighted means.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction
intervals around the line using \code{\link[ggplot2]{geom_ribbon}}.}

\item{int.type}{Type of interval to plot. Options are "confidence" or
"prediction". Default is confidence interval.}

\item{int.width}{How large should the interval be, relative to the standard
error? The default, .95, corresponds to roughly 1.96 standard errors and
a .05 alpha level for values outside the range. In other words, for a
confidence interval, .95 is analogous to a 95\% confidence interval.}

\item{outcome.scale}{For nonlinear models (i.e., GLMs), should the outcome
variable be plotted on the link scale (e.g., log odds for logit models) or
the original scale (e.g., predicted probabilities for logit models)? The
default is \code{"response"}, which is the original scale. For the link
scale, which will show straight lines rather than curves, use
\code{"link"}.}

\item{robust}{Should robust standard errors be used to find confidence
intervals for supported models? Default is FALSE, but you should specify
the type of sandwich standard errors if you'd like to use them (i.e.,
\code{"HC0"}, \code{"HC1"}, and so on). If \code{TRUE}, defaults to \code{"HC3"} standard
errors.}

\item{cluster}{For clustered standard errors, provide the column name of
the cluster variable in the input data frame (as a string). Alternately,
provide a vector of clusters.}

\item{vcov}{Optional. You may supply the variance-covariance matrix of the
coefficients yourself. This is useful if you are using some method for
robust standard error calculation not supported by the \pkg{sandwich}
package.}

\item{set.offset}{For models with an offset (e.g., Poisson models), sets an
offset for the predicted values. All predicted values will have the same
offset. By default, this is set to 1, which makes the predicted values a
proportion. See details for more about offset support.}

\item{new_data}{If you would prefer to generate your own hypothetical
(or not hypothetical) data rather than have the function make a call to
\code{\link[=make_new_data]{make_new_data()}}, you can provide it.}

\item{return.orig.data}{Instead of returning a just the predicted data frame,
should the original data be returned as well? If so, then a list will be
return with both the predicted data (as the first element) and the original
data (as the second element). Default is FALSE.}

\item{partial.residuals}{If \code{return.orig.data} is TRUE, should the observed
dependent variable be replaced with the partial residual? This makes a
call to \code{\link[=partialize]{partialize()}}, where you can find more details.}
}
\description{
This is an alternate interface to the underlying tools that
make up \code{\link[=effect_plot]{effect_plot()}} as well as \code{interact_plot} and \code{cat_plot} from
the \code{interactions} package.
\code{make_predictions} creates the data to be plotted and adds information
to the original data to make it more amenable for plotting with the
predicted data.
}
\concept{plotting tools}
