% Generated by roxygen2 (4.0.2): do not edit by hand
\name{unbox}
\alias{unbox}
\title{Unbox a vector or data frame}
\usage{
unbox(x)
}
\arguments{
\item{x}{atomic vector of length 1, or data frame with 1 row.}
}
\value{
Returns a singleton version of \code{x}.
}
\description{
This function marks an atomic vector or data frame as a
\href{http://en.wikipedia.org/wiki/Singleton_(mathematics)}{singleton}, i.e.
a set with exactly 1 element. Thereby, the value will not turn into an
\code{array} when encoded into JSON. This can only be done for
atomic vectors of length 1, or data frames with exactly 1 row. Because
this function alters how \R{} objects are encoded, it should be used
very sparsely, if at all.
}
\details{
It is usually recommended to avoid this function and stick with the default
encoding schema for the various \R{} classes. The only use case for this function
is if you are bound to some specific predefined JSON structure (e.g. to
submit to an API), which has no natural \R{} representation. Note that the default
encoding for data frames naturally results in a collection of key-value pairs,
without using \code{unbox}. If you are frequently using \code{unbox},
you're probably doing it wrong.
}
\examples{
toJSON(list(foo=123))
toJSON(list(foo=unbox(123)))

x <- iris[1,]
toJSON(list(rec=x))
toJSON(list(rec=unbox(x)))
}
\references{
\url{http://en.wikipedia.org/wiki/Singleton_(mathematics)}
}

