% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{DetermineDFromIRLBA}
\alias{DetermineDFromIRLBA}
\title{Create elbow plots of the singular values derived from IRLBA
to determine D for large datasets}
\usage{
DetermineDFromIRLBA(SickleJr, d = 50)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{d}{Number of desired factors; it is important to select a number that
allows you to see a clear elbow: defaults to 50.}
}
\value{
An object of class SickleJr with plots for IRLBA diagnostics added to its \code{plots} slot
}
\description{
This generates v+1 plots, where v is the number of data modalities, of the approximate
singular values generated by IRLBA.There is one plot for each modality and then a
final plot that concatenates all of the modalities together. Choose the largest elbow
value among the three plots.
}
\examples{
SimSickleJrSmall<-DetermineDFromIRLBA(SimSickleJrSmall,d=5)
}
\references{
\insertRef{irlba}{jrSiCKLSNMF}
}
