% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.h.R
\name{anova}
\alias{anova}
\title{ANOVA}
\usage{
anova(data, dep, factors = NULL, modelTerms = NULL, ss = "3",
  effectSize = NULL, contrasts = NULL, plotHAxis = NULL,
  plotSepLines = NULL, plotSepPlots = NULL, postHoc = NULL,
  postHocCorr = list("tukey"), descStats = FALSE, homo = FALSE,
  qq = FALSE, plotError = "ci", ciWidth = 95)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable from \code{data}, 
variable must be numeric}

\item{factors}{a vector of strings naming the fixed factors from 
\code{data}}

\item{modelTerms}{a list of character vectors describing the terms to go 
into the model}

\item{ss}{\code{'1'}, \code{'2'} or \code{'3'} (default), the sum of 
squares to use}

\item{effectSize}{one or more of \code{'eta'}, \code{'partEta'}, or 
\code{'omega'}; use eta², partial eta², and omega² effect sizes, 
respectively}

\item{contrasts}{a list of lists specifying the factor and type of contrast 
to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'}, 
\code{'helmert'}, \code{'repeated'} or \code{'polynomial'}}

\item{plotHAxis}{a string naming the variable placed on the horizontal axis 
of the plot}

\item{plotSepLines}{a string naming the variable represented as separate 
lines on the plot}

\item{plotSepPlots}{a string naming the variable to separate over to form 
multiple plots}

\item{postHoc}{a list of terms to perform post-hoc tests on}

\item{postHocCorr}{one or more of \code{'none'}, \code{'tukey'}, 
\code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey, 
Scheffe, Bonferroni, and Holm Post Hoc corrections respectively}

\item{descStats}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{homo}{\code{TRUE} or \code{FALSE} (default), perform homogeneity 
tests}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of 
residuals}

\item{plotError}{\code{'none'}, \code{'ci'} (default), or \code{'se'}. Use 
no error bars, use confidence intervals, or use standard errors on the 
plots, respectively}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the 
confidence interval width}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$main} \tab \tab \tab \tab \tab a table of ANOVA results \cr
  \code{results$assump$homo} \tab \tab \tab \tab \tab a table of homogeneity tests \cr
  \code{results$assump$qq} \tab \tab \tab \tab \tab a q-q plot \cr
  \code{results$contrasts} \tab \tab \tab \tab \tab an array of contrasts tables \cr
  \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
  \code{results$desc} \tab \tab \tab \tab \tab a table of descriptive statistics \cr
  \code{results$descPlot} \tab \tab \tab \tab \tab a descriptives plot \cr
  \code{results$descPlots} \tab \tab \tab \tab \tab an array of descriptives plots \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$main$asDF}

\code{as.data.frame(results$main)}
}
\description{
Analysis of Variance
}
\examples{
data('ToothGrowth')

anova(ToothGrowth, dep = 'len', factors = c('dose', 'supp'))

#
#  ANOVA
#
#  ANOVA
#  -----------------------------------------------------------------------
#                 Sum of Squares    df    Mean Square    F        p
#  -----------------------------------------------------------------------
#    dose                   2426     2         1213.2    92.00    < .001
#    supp                    205     1          205.4    15.57    < .001
#    dose:supp               108     2           54.2     4.11     0.022
#    Residuals               712    54           13.2
#  -----------------------------------------------------------------------
#

}
