% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jlmer.R
\name{to_jlmer}
\alias{to_jlmer}
\title{Fit a Julia regression model using lme4 syntax}
\usage{
to_jlmer(
  formula,
  data,
  family = c("gaussian", "binomial"),
  jlmer_spec_opts = list(),
  ...,
  progress = FALSE
)
}
\arguments{
\item{formula}{Model formula in R syntax}

\item{data}{A data frame}

\item{family}{A GLM family. Currently supports "gaussian" and "binomial".}

\item{jlmer_spec_opts}{List of options passed to \code{make_jlmer_spec()}}

\item{...}{Optional arguments passed to Julia for model fitting.}

\item{progress}{If \code{TRUE}, prints the timing of iterations.}
}
\value{
A \code{jlmer_mod} object.
}
\description{
Fit a Julia regression model using lme4 syntax
}
\examples{
\dontshow{if (JuliaConnectoR::juliaSetupOk()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
\dontshow{
options("jlmerclusterperm.nthreads" = 2)
jlmerclusterperm_setup(verbose = FALSE)
julia_progress(show = FALSE)
}

jlmerclusterperm_setup(verbose = FALSE)

# Fitting a regression model with R formula syntax
to_jlmer(weight ~ 1 + Diet, ChickWeight)

# `lm()` equivalent
summary(lm(weight ~ 1 + Diet, ChickWeight))$coef

# Fitting a mixed model with {lme4} syntax
to_jlmer(weight ~ 1 + Diet + (1 | Chick), ChickWeight)

# Passing MixedModels.jl fit options to the `...`
to_jlmer(weight ~ 1 + Diet + (1 | Chick), ChickWeight, REML = TRUE)

\dontshow{
JuliaConnectoR::stopJulia()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=jlmer]{jlmer()}}, \code{\link[=make_jlmer_spec]{make_jlmer_spec()}}
}
